;ZIP LOAD V2.21
;Please Note: The Disk must be 80 Trks, 10 Sectors and 2 Sides !!!

	opt s-
	clr.l -(sp)			;super mode
	move.w #$20,-(sp)
	trap #1
	addq.l #6,sp
	lea $80000,sp			;setup stack
	lea $ffff8240.w,a0		;black screen
	moveq #7,d0
clla	clr.l (a0)+
	dbf d0,clla
	clr.w ram			;clear ram flag
	cmp.l #$80000,$42e.w		;check for >=1 Meg
	ble halfmeg
*	move.w #1,ram			;set ram flag
halfmeg	lea text(pc),a0			;show text
	bsr print
	bsr fadeup			;fade colours up
	bsr getkey			;wait for key
	cmp.b #'/',d0			;check for disk loader
	bne notsp
	clr.w ram			;clear ram flag
notsp	or.b #$20,d0
	cmp.b #'t',d0
	bne notr
	clr.w $24.w
notr	bsr fadedn			;fade colours down
	move.w #1,$43e.w		;disable disk int
	lea handler(pc),a0		;copy handler
	lea $50000,a1			;address of handler
chl	move.l (a0)+,(a1)+		;copy data
	cmp.l #fadeup,a0		;end ?
	ble chl
	tst.w ram			;check ram flag
	beq norl
	bsr rload			;load whole disk
norl	move.w #0,d0
	move.w #648,d1			;start sector
	move.w #17,d2			;length in sectors
	move.w #0,d3
	lea $10000,a0			;load address
	jsr $50000			;call handler
	move.l #$4eb90005,$11cf8
	move.l #$00004e75,$11cfc
	move.l #$4ef80380,$11cc6
	lea cra1,a0
	lea $380,a1
cll2	move.l (a0)+,(a1)+
	cmp.l #cra2,a0
	ble cll2
	lea cra2,a0
	lea $3b4,a1
cll3	move.l (a0)+,(a1)+
	cmp.l #rload,a0
	ble cll3
	jmp $10000			;jump to bootblock

cra1	move.l #$4eb90005,$6163a
	move.l #$00004e75,$6163e
	move.w #$6022,$6160e
	move.w #$600c,$6022e
	move.l #$4ef803b4,$615e4
	jmp $60000
cra2	move.l #$4eb90001,$148a2
	move.l #$60004e75,$148a6
	lea $50000,a0
	lea $16000,a1
kk	move.l (a0)+,(a1)+
	cmp.l #$51f00,a0
	blt kk
	tst.w $24.w
	bne notrr
	move.w #1,$9300
	move.w #1,$92fc
notrr	jmp $1000.w

rload	pea ramess			;>=1 Meg found message
	move.w #9,-(sp)
	trap #1
	addq.l #6,sp
	bsr fadeup			;fade up colours
	move.w #0,-(sp)			;open disk file
	pea name
	move.w #$3d,-(sp)
	trap #1
	addq.l #8,sp
	move.w d0,d7
	pea $80100			;read disk file
	pea $fffff
	move.w d7,-(sp)
	move.w #$3f,-(sp)
	trap #1
	add.l #12,sp
	move.w d7,-(sp)			;close disk file
	move.w #$3e,-(sp)
	trap #1
	addq.l #4,sp
	bsr fadedn			;fade down colours
	rts				;return to main

handler	movem.l d1-a6,-(sp)		;lump handler
	clr.w	$500.w
	cmp.w 	#$46fc,$1000
	bne	noaa
	add.w	#800,d1
	tst.w	d0
	beq	noaa
	add.w	#800,d1
noaa	lea	data(pc),a6		;offset for relative vars
	tst.b	d3			;only read sector support
	bne	endh
	tst.w	d2
	beq	endh
	clr.w	sides-data(a6)
*	tst.w	d0			;check for single sided
*	beq	sing			;yes single
	move.w	#1,sides-data(a6)	;double sided access
sing	move.w	d1,d0			;start sector in D0
	move.w	d2,d1			;Length in D1
					;Address in A0
	move.w	d0,start_sec-data(a6)	;save parameters
	move.w	d1,length_sec-data(a6)
	move.l	a0,load_adds-data(a6)
	lea	ram(pc),a0		;ram flag
	tst.w	(a0)			;check for >=1 Meg
	bne	lram
	lea	$ffff8606.w,a5		;No, so must disk load
	lea	trackbuff(pc),a1	;track buffer
	move.l	a1,loadaddr-data(a6)
	move.l	a1,offset-data(a6)
	lea	name(pc),a0		;filename
	move.l	a0,filename-data(a6)
	bsr	do_boot			;get boot details
	bsr	do_dir			;open file
	move.w	load_sec-data(a6),old_sec-data(a6)	;save file start

readl	move.w	old_sec-data(a6),load_sec-data(a6)	;restor file start
lram	lea	trackbuff(pc),a1	;track buffer
	move.l	a1,loadaddr-data(a6)
	move.l	a1,offset-data(a6)
	move.w	start_sec-data(a6),d0	;get required sec
	divu	#10,d0			;which track ? (Note: SS)
	swap 	d0			;which sector ?
	move.w	d0,sector-data(a6)	;store sector
	swap 	d0			;track

	and.l	#$ffff,d0		;mask
	tst.w	sides-data(a6)
	bne	norm
	move.w	d0,d1
	divu	#1,d1
	mulu	#1,d1
	add.w	d1,d0
norm	lsl.l	#2,d0			;offset for table
	lea	table(pc),a0		;get table
	move.l	$0(a0,d0.l),d0		;get offset into file
	lea	ram(pc),a0		;ram flag
	tst.w	(a0)			;check for >=1 Meg
	beq	cdl			;no, so disk load
	add.l	#$80100,d0		;start of disk
	move.l	d0,a0			;address of required track
	move.l	loadaddr-data(a6),a1	;copy into track buffer
	move.w	#319,d0			;320*16 bytes
rdl	move.l	(a0)+,(a1)+		;copy data
	move.l	(a0)+,(a1)+		;copy data
	move.l	(a0)+,(a1)+		;copy data
	move.l	(a0)+,(a1)+		;copy data
	dbf	d0,rdl			;loop
	bra conl			;continue with handler
cdl	divu	#$200,d0		;which sector
	add.w	d0,load_sec-data(a6)	;add to start
	swap	d0			;get extra bytes
	and.l	#$ffff,d0		;mask
	add.l	d0,offset-data(a6)	;add to buffer start
	move.l	#$1600,load_len-data(a6);must read extra sector in case
					;track starts at +510 bytes !!
	bsr	do_file			;read file
conl	move.l	offset-data(a6),a0	;start of track
	bsr	decrunch		;depack
	move.w	sector-data(a6),d0	;sector in track
	move.w	d0,d1			;save sector
	mulu	#$200,d0		;sector length
	add.l	d0,a0			;sector address
	move.l	load_adds-data(a6),a1	;destination address
notes	move.l	#31,d0			;32*16 bytes long
copl	move.l	(a0)+,(a1)+		;copy data
	move.l	(a0)+,(a1)+		;copy data
	move.l	(a0)+,(a1)+		;copy data
	move.l	(a0)+,(a1)+		;copy data
	dbf	d0,copl			;loop
	subq.w	#1,length_sec-data(a6)	;1 sector copied
	beq	endh			;last sector
	addq.w	#1,d1			;1 sector copied
	cmp.w	#10,d1			;finished this track
	bne	notes			;no ?
	sub.w	sector-data(a6),d1	;how many sectors ?
	add.w 	d1,start_sec-data(a6)	;add sectors read
	mulu	#$200,d1		;length read
	add.l	d1,load_adds-data(a6)	;add length
	bra	readl			;round loop again
endh	movem.l (sp)+,d1-a6		;exit
	moveq #0,d0			;no errors
	rts				;return

name	dc.b 'CHUCK      ',0		;filename of lump

table	incbin 'g:\table'		;get track table

do_boot	; Read boot sector and calculate dir/data posns

	moveq	#0,d0
	bsr	read_log	Read boot sector
		
	move.l	loadaddr-data(a6),a0
	
	moveq	#0,d0
	moveq	#0,d1
	move.b	$10(a0),d0
	move.b	$16(a0),d1
	mulu	d1,d0
	addq.w	#1,d0
	move.w	d0,dir_pos-data(a6)

	move.b	$11(a0),d1
	lsr.w	#4,d1
	move.w	d1,dir_len-data(a6)

	rts


do_dir	; Reads dir and get load_sec and load_len

	move.w	dir_pos-data(a6),d6
	move.w	dir_len-data(a6),d7
	add.w	d7,dir_pos-data(a6)	Posn of cluster 2

.1	move.w	d6,d0
	bsr	read_log
	
	moveq	#15,d0		16 file entries per sec
	move.l	loadaddr-data(a6),a0
	move.l	filename-data(a6),a1

.2	moveq	#10,d1		11 chars in filename

.3	move.b	0(a0,d1.w),d2
	cmp.b	0(a1,d1.w),d2
	bne	.4
	dbf	d1,.3
	lea	26(a0),a0		File found!
	lea	load_sec+2-data(a6),a1
	move.b	(a0)+,-(a1)
	move.b	(a0)+,-(a1)
	move.w	load_sec-data(a6),d0
	subq.w	#2,d0
	add.w	d0,d0
	add.w	dir_pos-data(a6),d0
	move.w	d0,load_sec-data(a6)
	moveq	#0,d0
	rts

.4	lea	32(a0),a0		Next entry
	dbf	d0,.2

	addq.w	#1,d6		Next dir sector
	subq.w	#1,d7	
	bpl	.1
	rts			d0=-1,file not found error


do_file	; Read file in!

	move.w	load_sec-data(a6),d0
	ext.l	d0
	bsr	calc_sec		d0=trk,d1=sec
	move.w	d1,d2
	mulu	#$200,d2
	move.l	#$1600,d3
	sub.l	d2,d3		d3=max load amount of this track
	move.l	load_len-data(a6),d2
	cmp.l	d2,d3
	bge.s	.1
	move.l	d3,d2
.1	move.l	d2,-(a7)		d2=amount
	bsr	readdisk
	move.l	(a7)+,d2
	add.l	d2,loadaddr-data(a6)
	sub.l	d2,load_len-data(a6)
	divu	#$200,d2
	add.w	d2,load_sec-data(a6)
	tst.l	load_len-data(a6)
	bne.s	do_file		More to load?
	rts
	

; Little subbies (!)

read_log	; Read logical sector in d0

	bsr	calc_sec
	move.l	#$200,d2		One sector only
	bsr.s	readdisk
	rts


readdisk	; Read d0=trk,d1=sec,d2=amount

	move.w	d1,d4			Sector to d4
	add.w	#$1ff,d2
	divu	#$200,d2
	move.w	d2,d3			Count to d3
	move.l	loadaddr-data(a6),a0	Load address

	move.w	#$86,(a5)		Move head to track d0
	move.w	d0,d1
	bsr	shove_fdc
	move.w	#$80,(a5)
	move.w	#$13,d1
	bsr	shove_fdc
	bsr	wait_fdc
	bmi	stat_bad
	move.w	#$82,(a5)		Set track register
	move.w	d0,d1		d0=track
	bsr	shove_fdc
.next_sec	moveq	#2,d5		3 tries
.err_loop	move.l	a0,d1
	move.b	d1,7(a5)
	lsr.l	#8,d1
	move.b	d1,5(a5)
	lsr.w	#8,d1
	move.b	d1,3(a5)
	move.w	#$84,(a5)
	move.w	d4,d1		d4=sec
	bsr	shove_fdc
	move.w	#$90,(a5)
	move.w	#$190,(a5)
	move.w	#$90,(a5)
	move.w	#$1,d1		1 sec
	bsr	shove_fdc
	move.w	#$80,(a5)
	move.w	#$80,d1
	bsr	shove_fdc
	bsr	wait_fdc		Read sec
	bmi	stat_bad
	move.w	-2(a5),d1
	and.w	#$70,d1
	beq.s	.ok
	dbf	d5,.err_loop
	bra	stat_bad
.ok	lea	$200(a0),a0
	addq.w	#1,d4
	subq.w	#1,d3
	bne	.next_sec
	rts

shove_fdc
	bsr.s	.1
	move.w	d1,-2(a5)
.1	moveq	#32,d2
.2	dbf	d2,.2
	rts

wait_fdc
	move.l	#$400000,d1
.1	btst	#5,$fffa01
	beq.s	.2
	subq.l	#1,d1
	bpl	.1
	rts
.2	moveq	#0,d1
	rts

stat_bad
	addq.l	#8,a7		Error
	bra	select_2
	

calc_sec	; Logical sector in d0,outputs trk,sec in d0,d1

	divu	#10,d0
	btst	#0,d0
	bne.s	.1
	bsr	select_0	Side 0
	bra.s	.2
.1	bsr	select_1	Side 1
.2	move.l	d0,d1
	lsr.w	#1,d0	Trk
	swap	d1
	addq.w	#1,d1	Sec
	rts

select_0
	movem.l	d0-d1,-(a7)	Select side 0
	moveq	#5,d0	
	bra.s	sel

select_1
	movem.l	d0-d1,-(a7)	Select side 1
	moveq	#4,d0	
	bra.s	sel

select_2
	movem.l	d0-d1,-(a7)	Select nothing
	moveq	#7,d0	

sel	move	sr,-(a7)
	or	#$700,sr
	move.b	#$e,$ffff8800.w
	move.b	$ffff8800.w,d1
	and.b	#$f8,d1
	or.b	d0,d1
	move.b	d1,$ffff8802.w
	move	(a7)+,sr
	movem.l	(a7)+,d0-d1
	rts


data	; All variables relative to this for pos-ind code

filename	dc.l	0	;Address of filename
loadaddr	dc.l	0	;Load address for buffer
load_sec	dc.w	0	;Sector to load from
load_len	dc.l	0	;File length left to load
dir_pos	dc.w	0		;Start sec of directory (then data)
dir_len	dc.w	0		;Directory length in secs	
start_sec	dc.w 	0	;Sector to load from
length_sec	dc.w	0	;Length of sectors to load
load_adds	dc.l	0	;Address to load to
offset		dc.l	0	;Address of sector in buffer
sector		dc.w	0	;Which sector in track
old_sec		dc.w	0	;Temp storage for start of file
sides		dc.w	0	;Single or Double sided access
ram		dc.w	0	;Flag for ram disk

;********************************************* Unpackroutine von ICE-PACK
; Eingabe: a0 = Adresse gepackter Daten
decrunch
	move.w	$ffff8240.w,-(sp)
	link	a3,#-120
	movem.l	d0-a6,-(sp)
	lea	120(a0),a4	; a4 = Anfang entpackte Daten
	move.l	a4,a6		; a6 = Ende entpackte Daten
	bsr.s	.getinfo
	cmpi.l	#'ICE!',d0	; Kennung gefunden?
	bne	.not_packed
	bsr.s	.getinfo		; gepackte Lnge holen
	lea.l	-8(a0,d0.l),a5	; a5 = Ende der gepackten Daten
	bsr.s	.getinfo		; ungepackte Lnge holen (original)
	move.l	d0,(sp)		; Originallnge: spter nach d0
	adda.l	d0,a6		; a6 = Ende entpackte Daten
	move.l	a6,a1

	moveq	#119,d0		; 120 Bytes hinter entpackten Daten
.save:	move.b	-(a1),-(a3)	; in sicheren Bereich sichern
	dbf	d0,.save
	move.l	a6,a3		; merken fr Picture decrunch
	move.b	-(a5),d7		; erstes Informationsbyte
	bsr.s	.normal_bytes
	move.l	a3,a5		; fr 120 Bytes restore

.no_picture
	movem.l	(sp),d0-a3	; hole ntige Register

.move	move.b	(a4)+,(a0)+
	subq.l	#1,d0
	bne.s	.move
	moveq	#119,d0		; um berschriebenen Bereich
.rest	move.b	-(a3),-(a5)	; wieder herzustellen
	dbf	d0,.rest
.not_packed:
	movem.l	(sp)+,d0-a6
	unlk	a3
	move.w	(sp)+,$ffff8240.w
	rts

.getinfo: moveq	#3,d1		; ein Langwort vom Anfang
.getbytes: lsl.l	#8,d0		; der Daten lesen
	move.b	(a0)+,d0
	dbf	d1,.getbytes
	rts

.normal_bytes:	
	bsr.s	.get_1_bit
	bcc.s	.test_if_end	; Bit %0: keine Daten
	moveq.l	#0,d1		; falls zu copy_direkt
	bsr.s	.get_1_bit
	bcc.s	.copy_direkt	; Bitfolge: %10: 1 Byte direkt kop.
	lea.l	.direkt_tab+20(pc),a1
	moveq.l	#4,d3
.nextgb:	move.l	-(a1),d0		; d0.w Bytes lesen
	bsr.s	.get_d0_bits
	swap.w	d0
	cmp.w	d0,d1		; alle gelesenen Bits gesetzt?
	dbne	d3,.nextgb	; ja: dann weiter Bits lesen
.no_more: add.l	20(a1),d1 	; Anzahl der zu bertragenen Bytes
.copy_direkt:	
	move.b	-(a5),-(a6)	; Daten direkt kopieren
	eor.w	#$777,$ffff8240.w
	dbf	d1,.copy_direkt	; noch ein Byte
.test_if_end:	
	cmpa.l	a4,a6		; Fertig?
	bgt.s	.strings		; Weiter wenn Ende nicht erreicht
	rts	

;************************** Unterroutinen: wegen Optimierung nicht am Schlu

.get_1_bit:
	add.b	d7,d7		; hole ein bit
	bne.s	.bitfound 	; quellfeld leer
	move.b	-(a5),d7		; hole Informationsbyte
	addx.b	d7,d7
.bitfound:
	rts	

.get_d0_bits:	
	moveq.l	#0,d1		; ergebnisfeld vorbereiten
.hole_bit_loop:	
	add.b	d7,d7		; hole ein bit
	bne.s	.on_d0		; in d7 steht noch Information
	move.b	-(a5),d7		; hole Informationsbyte
	addx.b	d7,d7
.on_d0:	addx.w	d1,d1		; und bernimm es
	dbf	d0,.hole_bit_loop	; bis alle Bits geholt wurden
	rts	

;************************************ Ende der Unterroutinen


.strings: lea.l	.length_tab(pc),a1	; a1 = Zeiger auf Tabelle
	moveq.l	#3,d2		; d2 = Zeiger in Tabelle
.get_length_bit:	
	bsr.s	.get_1_bit
	dbcc	d2,.get_length_bit	; nchstes Bit holen
.no_length_bit:	
	moveq.l	#0,d4		; d4 = berschu-Lnge
	moveq.l	#0,d1
	move.b	1(a1,d2.w),d0	; d2: zw. -1 und 3; d3+1: Bits lesen
	ext.w	d0		; als Wort behandeln
	bmi.s	.no_ber		; kein berschu ntig
.get_ber:
	bsr.s	.get_d0_bits
.no_ber:	move.b	6(a1,d2.w),d4	; Standard-Lnge zu berschu add.
	add.w	d1,d4		; d4 = String-Lnge-2
	beq.s	.get_offset_2	; Lnge = 2: Spezielle Offset-Routine


	lea.l	.more_offset(pc),a1 ; a1 = Zeiger auf Tabelle
	moveq.l	#1,d2
.getoffs: bsr.s	.get_1_bit
	dbcc	d2,.getoffs
	moveq.l	#0,d1		; Offset-berschu
	move.b	1(a1,d2.w),d0	; request d0 Bits
	ext.w	d0		; als Wort
	bsr.s	.get_d0_bits
	add.w	d2,d2		; ab jetzt: Pointer auf Worte
	add.w	6(a1,d2.w),d1	; Standard-Offset zu berschu add.
	bpl.s	.depack_bytes	; keine gleiche Bytes: String kop.
	sub.w	d4,d1		; gleiche Bytes
	bra.s	.depack_bytes


.get_offset_2:	
	moveq.l	#0,d1		; berschu-Offset auf 0 setzen
	moveq.l	#5,d0		; standard: 6 Bits holen
	moveq.l	#-1,d2		; Standard-Offset auf -1
	bsr.s	.get_1_bit
	bcc.s	.less_40		; Bit = %0
	moveq.l	#8,d0		; quenty fourty: 9 Bits holen
	moveq.l	#$3f,d2		; Standard-Offset: $3f
.less_40: bsr.s	.get_d0_bits
	add.w	d2,d1		; Standard-Offset + ber-Offset

.depack_bytes:			; d1 = Offset, d4 = Anzahl Bytes
	lea.l	2(a6,d4.w),a1	; Hier stehen die Originaldaten
	adda.w	d1,a1		; Dazu der Offset
	move.b	-(a1),-(a6)	; ein Byte auf jeden Fall kopieren
.dep_b:	move.b	-(a1),-(a6)	; mehr Bytes kopieren
	dbf	d4,.dep_b 	; und noch ein Mal
	bra	.normal_bytes	; Jetzt kommen wieder normale Bytes


.direkt_tab:
	dc.l $7fff000e,$00ff0007,$00070002,$00030001,$00030001	; Anzahl 1-Bits
	dc.l     270-1,	15-1,	 8-1,	 5-1,	 2-1	; Anz. Bytes

.length_tab:
	dc.b 9,1,0,-1,-1		; Bits lesen
	dc.b 8,4,2,1,0		; Standard-Lnge - 2 (!!!)

.more_offset:
	dc.b	  11,   4,   7,  0	; Bits lesen
	dc.w	$11f,  -1, $1f	; Standard Offset

ende_ice_decrunch_2:
;*************************************************** Ende der Unpackroutine

trackbuff	ds.l 1408

fadeup	move.w #6,d0
ful	move.w #$1234,d2
	move.w #$2000,d1
paa	mulu d1,d2
	dbf d1,paa
	add.w #$111,$ffff825e.w
	dbf d0,ful
	rts

fadedn	move.w #6,d0
ful1	move.w #$1234,d2
	move.w #$2000,d1
paa1	mulu d1,d2
	dbf d1,paa1
	sub.w #$111,$ffff825e.w
	dbf d0,ful1
	rts

getkey	move.w #7,-(sp)
	trap #1
	addq.l #2,sp
	rts

print	pea (a0)
	move.w #9,-(sp)
	trap #1
	addq.l #6,sp
	rts

ramess		dc.b 27,'f',27,'E'
		dc.b "ZIP-LOAD V2.21",10,10,13
		dc.b "1 Meg (or more) of Ram Detected.",10,10,13
		dc.b "Creating Ram Disk, Please wait....",0
text		dc.b 27,'f',27,'E'
		dc.b "The Medway Boys Present",10,13
		DC.B "~~~~~~~~~~~~~~~~~~~~~~~",10,10,13
		DC.B "Chuck Rock+",10,10,13
		dc.b "Cracked/Packed/Filed/Trained by ZIPPY",10,13
		dc.b "Original by Mike of Trend",10,10,13
		dc.b "Press 'T' for trainer",10,13
		dc.b "(Trainer gives Infinite energy and you",10,13
		dc.b "can press 1-5 to skip levels DURING the",10,13
		dc.b "game !!)",10,10,10,13
		dc.b "This game now uses ZIP-LOAD V2.21"
	even
		dc.w 0
		
